SuperStrict

Import brl.pixmap
Import "pixels.bmx"
Import "interpolate.bmx"
Import "rectangle.bmx"


' TODO: fix pastesubpixmaprectinc



Function SetPixmapAlpha(pix:TPixmap,a%)
	a=a Shl 24
	For Local x%=0 Until pix.width
		For Local y%=0 Until pix.height
			pix.WritePixel x,y,pix.ReadPixel(x,y)&$ffffff|a
		Next
	Next
End Function
Function SetPixmapColor(pix:TPixmap,rgb%)
	For Local x%=0 Until pix.width
		For Local y%=0 Until pix.height
			pix.WritePixel x,y,pix.ReadPixel(x,y)&$ff000000|rgb
		Next
	Next
End Function


Function PasteSubPixmapRect(src:TPixmap,dest:TPixmap,x%,y%,w%,h%,sx%,sy%,sw%,sh%,interpolate%=0)
	If interpolate Then
		pastesubpixmaprectint src,dest,x,y,w,h,sx,sy,sw-1,sh-1
	Else
		pastesubpixmaprectnn src,dest,x,y,w,h,sx,sy,sw,sh
	EndIf
End Function


Function PasteSubPixmapRectNN(src:TPixmap,dest:TPixmap,x%,y%,w%,h%,sx%,sy%,sw%,sh%)
	If 0'w=sw And h=sh Then
		PastePixmap11 src,dest,x,y
	Else
		Select src.format
			Case PF_RGBA8888
				PasteSubPixmapRectNNRGBA src,dest,x,y,w,h,sx,sy,sw,sh
			Case PF_BGRA8888
				PasteSubPixmapRectNNBGRA src,dest,x,y,w,h,sx,sy,sw,sh
			Default
				PasteSubPixmapRectNNelse src,dest,x,y,w,h,sx,sy,sw,sh
		End Select
	EndIf
End Function



' for pasting a pixmap at a 1:1 ratio
Function PastePixmap11(src:TPixmap,dest:TPixmap,x%=0,y%=0,w%=-1,h%=-1,sx%=0,sy%=0)
	If w=-1 Then w=src.width
	If h=-1 Then h=src.height
	If x<0 Then sx:-x;x=0
	If y<0 Then sy:-y;y=0
	Local drawfrom:rectangle=rectintersection(sx,sy,w,h,0,0,src.width,src.height)
	Local drawto:rectangle=rectintersection(x,y,drawfrom.w,drawfrom.h,0,0,dest.width,dest.height)
	If Not(drawfrom.exists() And drawto.exists()) Then Return
	Local xstart%=drawfrom.x
	Local ystart%=drawfrom.y
	Local xbound%=drawfrom.x+Min(drawfrom.w,drawto.w)
	Local ybound%=drawfrom.y+Min(drawfrom.h,drawto.h)
	Local xx%,yy%=drawto.y
	For Local ypos%=ystart Until ybound
		xx=drawto.x
		For Local xpos%=xstart Until xbound
			WritePixelAlpha dest,xx,yy,src.ReadPixel(xpos,ypos)
			xx:+1
		Next
		yy:+1
	Next
End Function

' for pasting a pixmap at a 1:1 ratio because of using wrap instead of scale
Function PastePixmap11Wrapped(src:TPixmap,dest:TPixmap,x%,y%,w%=-1,h%=-1,sx%=0,sy%=0)
	If w=-1 Then w=src.width
	If h=-1 Then h=src.height
	Local drawto:rectangle=rectintersection(x,y,w,h,0,0,dest.width,dest.height)
	If Not(drawto.exists()) Then Return
	Local xstart%=((sx Mod src.width)+src.width) Mod src.width'drawto.x
	Local ystart%=((sy Mod src.height)+src.height) Mod src.height'drawto.y
	Local xbound%=xstart+w'drawto.x+drawto.w
	Local ybound%=ystart+h'drawto.y+drawto.h
	Local xx%,yy%=drawto.y
	For Local ypos%=ystart Until ybound
		xx=drawto.x
		For Local xpos%=xstart Until xbound
			WritePixelAlpha dest,xx,yy,src.ReadPixel(xpos Mod src.width,ypos Mod src.height)
			xx:+1
		Next
		yy:+1
	Next
End Function

' baseline for anything not specifically allocated otherwise
Function PasteSubPixmapRectNNelse(src:TPixmap,dest:TPixmap,x%,y%,w%,h%,sx%,sy%,sw%,sh%)
	Local drawfrom:rectangle=rectintersection(sx,sy,sw,sh,0,0,src.width,src.height)
	Local drawto:rectangle=rectintersection(x,y,w,h,0,0,dest.width,dest.height)
	If Not(drawfrom.exists() And drawto.exists()) Then Return
	Local xstart%=drawto.x
	Local ystart%=drawto.y
	Local xbound%=drawto.x+drawto.w
	Local ybound%=drawto.y+drawto.h
	Local xxinc!=drawfrom.w/Double(w)
	Local yyinc!=drawfrom.h/Double(h)
	drawfrom.x:+(drawto.x-x)*xxinc
	drawfrom.y:+(drawto.y-y)*yyinc
	Local xx!,yy!=drawfrom.y
	For Local ypos%=ystart Until ybound
		xx=drawfrom.x
		For Local xpos%=xstart Until xbound
			WritePixelAlpha dest,xpos,ypos,src.ReadPixel(xx,yy)
			xx:+xxinc
		Next
		yy:+yyinc
	Next
End Function

' fast for PF_RGBA8888
Function PasteSubPixmapRectNNRGBA(src:TPixmap,dest:TPixmap,x%,y%,w%,h%,sx%,sy%,sw%,sh%)
	Local drawfrom:rectangle=rectintersection(sx,sy,sw,sh,0,0,src.width,src.height)
	Local drawto:rectangle=rectintersection(x,y,w,h,0,0,dest.width,dest.height)
	If Not(drawfrom.exists() And drawto.exists()) Then Return
	Local xstart%=drawto.x
	Local ystart%=drawto.y
	Local xbound%=drawto.x+drawto.w
	Local ybound%=drawto.y+drawto.h
	Local xxinc!=drawfrom.w/Double(w)
	Local yyinc!=drawfrom.h/Double(h)
	drawfrom.x:+(drawto.x-x)*xxinc
	drawfrom.y:+(drawto.y-y)*yyinc
	Local xx!,yy!=drawfrom.y
	If src.format<>PF_RGBA8888 Then src=src.convert(PF_RGBA8888)
	Local p@ Ptr
	For Local ypos%=ystart Until ybound
		xx=drawfrom.x
		For Local xpos%=xstart Until xbound
			p=src.pixelptr(Int(xx),Int(yy))
			WritePixelAlpha dest,xpos,ypos,p[0] Shl 16 | p[1] Shl 8 | p[2] | p[3] Shl 24
			xx:+xxinc
		Next
		yy:+yyinc
	Next
End Function

' faster,for PF_BGRA8888
Function PasteSubPixmapRectNNBGRA(src:TPixmap,dest:TPixmap,x%,y%,w%,h%,sx%,sy%,sw%,sh%)
	Local drawfrom:rectangle=rectintersection(sx,sy,sw,sh,0,0,src.width,src.height)
	Local drawto:rectangle=rectintersection(x,y,w,h,0,0,dest.width,dest.height)
	If Not(drawfrom.exists() And drawto.exists()) Then Return
	Local xstart%=drawto.x
	Local ystart%=drawto.y
	Local xbound%=drawto.x+drawto.w
	Local ybound%=drawto.y+drawto.h
	Local xxinc!=drawfrom.w/Double(w)
	Local yyinc!=drawfrom.h/Double(h)
	drawfrom.x:+(drawto.x-x)*xxinc
	drawfrom.y:+(drawto.y-y)*yyinc
	Local xx!=drawfrom.x,yy!
	If src.format<>PF_BGRA8888 Then src=src.convert(PF_BGRA8888)
	Local p% Ptr=Int Ptr src.pixels,py%
	For Local ypos%=ystart Until ybound
		xx=drawfrom.x
		py=(Int(yy)*(src.pitch Shr 2))
		For Local xpos%=xstart Until xbound
			WritePixelAlpha dest,xpos,ypos,p[py+Int(xx)]
			xx:+xxinc
		Next
		yy:+yyinc
	Next
End Function


' interpolate
Function PasteSubPixmapRectInt(src:TPixmap,dest:TPixmap,x%,y%,w%,h%,sx%,sy%,sw%,sh%)
	Local drawfrom:rectangle=rectintersection(sx,sy,sw,sh,0,0,src.width,src.height)
	Local drawto:rectangle=rectintersection(x,y,w,h,0,0,dest.width,dest.height)
	If Not(drawfrom.exists() And drawto.exists()) Then Return
	Local xstart%=drawto.x
	Local ystart%=drawto.y
	Local xbound%=drawto.x+drawto.w
	Local ybound%=drawto.y+drawto.h
	Local xxinc!=drawfrom.w/Double(w)
	Local yyinc!=drawfrom.h/Double(h)
	drawfrom.x:+(drawto.x-x)*xxinc
	drawfrom.y:+(drawto.y-y)*yyinc
	Local xx!=drawfrom.x,yy!=drawfrom.y
	Local precalcx![xbound-xstart],ceilx%[precalcx.length]
	For Local xpos%=0 Until precalcx.length-1
		Local tx%=Int(xx)
		ceilx[xpos]=Ceil(xx+xxinc)
		precalcx[xpos]=(xx-tx)/Double(ceilx[xpos]-tx)
		xx:+xxinc
	Next
	ceilx[ceilx.length-1]=Int(xx)
	precalcx[ceilx.length-1]=0
	For Local ypos%=ystart Until ybound
		xx=drawfrom.x
		Local ty%=Int(yy),ceily%=Ceil(yy+yyinc)
		Local calcy!=(yy-ty)/(ceily-ty)
		Local xposi%=0
		If ypos=ybound-1 Then
			ceily=ty
			calcy=0
		EndIf
		For Local xpos%=xstart Until xbound
			Local tx%=Int(xx)
			Local value%=InterpolatePixels(src.ReadPixel(tx,ty),src.ReadPixel(ceilx[xposi],ty),src.ReadPixel(tx,ceily),src.ReadPixel(ceilx[xposi],ceily),precalcx[xposi],calcy)
			WritePixelAlpha dest,xpos,ypos,value
			xposi:+1
			xx:+xxinc
		Next
		yy:+yyinc
	Next
End Function


Function InterpolatePixels%(topleft%,topright%,bottomleft%,bottomright%,x!,y!)
	Local tla%=( topleft Shr 24 )
	Local tlr%=( topleft Shr 16 ) & $ff
	Local tlg%=( topleft Shr 8  ) & $ff
	Local tlb%=( topleft ) & $ff
	Local tra%=( topright Shr 24 )
	Local trr%=( topright Shr 16 ) & $ff
	Local trg%=( topright Shr 8  ) & $ff
	Local trb%=( topright ) & $ff
	Local bla%=( bottomleft Shr 24 )
	Local blr%=( bottomleft Shr 16 ) & $ff
	Local blg%=( bottomleft Shr 8  ) & $ff
	Local blb%=( bottomleft ) & $ff
	Local bra%=( bottomright Shr 24 )
	Local brr%=( bottomright Shr 16 ) & $ff
	Local brg%=( bottomright Shr 8  ) & $ff
	Local brb%=( bottomright ) & $ff
	Local lefta%= interpolate_linear(tla,bla,y)
	Local leftr%= interpolate_linear(tlr,blr,y)
	Local leftg%= interpolate_linear(tlg,blg,y)
	Local leftb%= interpolate_linear(tlb,blb,y)
	Local righta%=interpolate_linear(tra,bra,y)
	Local rightr%=interpolate_linear(trr,brr,y)
	Local rightg%=interpolate_linear(trg,brg,y)
	Local rightb%=interpolate_linear(trb,brb,y)
	Local valuea%=interpolate_linear(lefta,righta,x)
	Local valuer%=interpolate_linear(leftr,rightr,x)
	Local valueg%=interpolate_linear(leftg,rightg,x)
	Local valueb%=interpolate_linear(leftb,rightb,x)
	Return (valuea Shl 24)|(valuer Shl 16)|(valueg Shl 8)|valueb
End Function


Function PixRow(target:TPixmap,x%,y%,width%,color%)
	For Local xx%=Max(0,x) Until Min(target.width,x+width)
		WritePixelAlpha target,xx,y,color
	Next
End Function

Function PixColumn(target:TPixmap,x%,y%,height%,color%)
	For Local yy%=Max(0,y) Until Min(target.height,y+height)
		WritePixelAlpha target,x,yy,color
	Next
End Function

Function PixLine%(target:TPixmap,x0%,y0%,x1%,y1%,color%)
	Local dx%=Abs(x1-x0),dy%=Abs(y1-y0),sx%=-1,sy%=-1
	If x0<x1 Then sx=1
	If y0<y1 Then sy=1
	Local err%=dx-dy,e2%
	Local pixels%=0
	Repeat
		WritePixelAlpha target,x0,y0,color
		pixels:+1
		If x0=x1 And y0=y1 Then Exit
		e2=err*2
		If e2>-dy Then err:-dy;x0:+sx
		If e2<dx Then err:+dx;y0:+sy
	Forever
	Return pixels
End Function

Function PixThickLine(target:TPixmap,x0%,y0%,x1%,y1%,color%)
	Local dx%=Abs(x1-x0),dy%=Abs(y1-y0),sx%=-1,sy%=-1
	If x0<x1 Then sx=1
	If y0<y1 Then sy=1
	Local err%=dx-dy,e2%
	Repeat
		For Local xx%=-1 To 1
		For Local yy%=-1 To 1
			WritePixelAlpha target,x0+xx,y0+yy,color
		Next
		Next
		If x0=x1 And y0=y1 Then Exit
		e2=err*2
		If e2>-dy Then err:-dy;x0:+sx
		If e2<dx Then err:+dx;y0:+sy
	Forever
End Function

Function PixFillRect(target:TPixmap,x%,y%,w%,h%,color%)
	Local xbound%=x+w
	Local ybound%=y+h
	For Local xx%=Max(0,x) Until Min(target.width,xbound)
		For Local yy%=Max(0,y) Until Min(target.height,ybound)
			WritePixelAlpha target,xx,yy,color
		Next
	Next
End Function

Function PixOutlineRect(target:TPixmap,x%,y%,w%,h%,color%)
	Local lowery%=y+h-1
	Local rightx%=x+w-1
	Local doy1%,doy2%,dox1%,dox2%
	If y>=0 And y<target.height Then doy1=True
	If lowery>=0 And lowery<target.height Then doy2=True
	If x>=0 And x<target.width Then dox1=True
	If rightx>=0 And rightx<target.width Then dox2=True
	If doy1 And doy2
		For Local xx%=Max(0,x) Until Min(target.width,x+w)
			WritePixelAlpha target,xx,y,color
			WritePixelAlpha target,xx,lowery,color
		Next
	ElseIf doy1
		For Local xx%=Max(0,x) Until Min(target.width,x+w)
			WritePixelAlpha target,xx,y,color
		Next
	ElseIf doy2
		For Local xx%=Max(0,x) Until Min(target.width,x+w)
			WritePixelAlpha target,xx,lowery,color
		Next
	EndIf
	If dox1 And dox2
		For Local yy%=Max(0,y+1) Until Min(target.height,y+h-1)
			WritePixelAlpha target,x,yy,color
			WritePixelAlpha target,rightx,yy,color
		Next
	ElseIf dox1
		For Local yy%=Max(0,y+1) Until Min(target.height,y+h-1)
			WritePixelAlpha target,x,yy,color
		Next
	ElseIf dox2
		For Local yy%=Max(0,y+1) Until Min(target.height,y+h-1)
			WritePixelAlpha target,rightx,yy,color
		Next
	EndIf
End Function

Function PixFillOval(target:TPixmap,xc%,yc%,w%,h%,color%) 'x,y is center, width and height are radii
	If h=0 Or w=0 PixFillRect target,xc-w,yc-h,2*w+1,2*h+1,color;Return
	Local x%=0,y%=h,width%=1,a2%=w*w,b2%=h*h
	Local crit1%=-(a2/4+(w Mod 2)+b2),crit2%=-(b2/4+(h Mod 2)+a2),crit3%=-(b2/4+(h Mod 2))
	Local t%=-a2*y,dxt%=2*b2*x,dyt%=-2*a2*y,d2xt%=2*b2,d2yt%=2*a2
	While(y>=0 And x<=w)
		If t+b2*x<=crit1 Or t+a2*y<=crit3 
			x:+1;dxt:+d2xt;t:+dxt
			width:+2
		ElseIf t-a2*y>crit2
			PixRow target,xc-x,yc-y,width,color
			If y<>0 PixRow target,xc-x,yc+y,width,color
			y:-1;dyt:+d2yt;t:+dyt
		Else
			PixRow target,xc-x,yc-y,width,color
			If y<>0 PixRow target,xc-x,yc+y,width,color
			x:+1;dxt:+d2xt;t:+dxt
			y:-1;dyt:+d2yt;t:+dyt
			width:+2
		EndIf
	Wend
End Function 
	
Function PixOutlineOval(target:TPixmap,cx%,cy%,w%,h%,color%) 'cx and cy are the center, width and height are radii. (doesn't play nice if you want an odd number for diameter.)
	If w<1 And h<1 WritePixelAlpha target,cx,cy,color;Return
	Local x%=w,y%=0,xchange%=h*h*(1-2*w),ychange%=w*w,ellipseerror%=0,twoasquare%=2*w*w,twobsquare%=2*h*h,stoppingx%=twobsquare*w,stoppingy%=0
	While(stoppingx>=stoppingy)
		WritePixelAlpha target,cx+x,cy+y,color
		WritePixelAlpha target,cx-x,cy+y,color
		WritePixelAlpha target,cx+x,cy-y,color
		WritePixelAlpha target,cx-x,cy-y,color
		y:+1;stoppingy:+twoasquare;ellipseerror:+ychange;ychange:+twoasquare
		If (2*ellipseerror+xchange)>0 x:-1;stoppingx:-twobsquare;ellipseerror:+xchange;xchange:+twobsquare
	Wend
	x=0;y=h;xchange=h*h;ychange=w*w*(1-2*h);ellipseerror=0;stoppingx=0;stoppingy=twoasquare*h
	While(stoppingx<=stoppingy)
		WritePixelAlpha target,cx+x,cy+y,color
		WritePixelAlpha target,cx-x,cy+y,color
		WritePixelAlpha target,cx+x,cy-y,color
		WritePixelAlpha target,cx-x,cy-y,color
		x:+1;stoppingx:+twobsquare;ellipseerror:+xchange;xchange:+twobsquare
		If (2*ellipseerror+ychange)>0 y:-1;stoppingy:-twoasquare;ellipseerror:+ychange;ychange:+twoasquare
	Wend
End Function 